//
// MyString.h
//
// This is the MyString string class.
//
// Version 0.5
//   -- Fix minor incompatabilities with various compilers
//

class MyString
{
public:
  // Constructors
  MyString();
  MyString(string);
  MyString(MyString &aCopy);
  
  // Destructor
  virtual ~MyString();
  
  // Operator overloads
  MyString &operator=(const MyString &sourceStr);
  int operator~() const;
  string operator +() const;
  char &operator[](int i) const;

  operator string() const;  
  string MakeString() const;
  int MakeInt() const;
  bool setValue(string newValue);
  
  // Here comes the declarations for the overloaded
  // readString() member function.
  int readString();
  int readString(int maxSpace);
  
  int findChar(char c,int startPos=0,int stopPos=-1);
  char &element(int i);
  
  
private:
  bool growStorage(int);
  char *storagePtr;
  char initialStorage[20];
  int allocatedSpace;
  int stringLength;
  char tempStorage;
};

inline MyString operator+(const MyString &str1, const MyString &str2)
{
  MyString retStr((+str1)+(+str2));
  return retStr;
}

